/********************************************************************
 FileName:     	HardwareProfile base-pic32mx.h
 Dependencies:  See INCLUDES section
 Processor:     PIC32MX250F128B
 Hardware:      ET-BASE PIC32MX
 Compiler:      Microchip XC32

**********************************************************************/

#ifndef HARDWARE_PROFILE_ET_BASE_PIC32MX_H
#define HARDWARE_PROFILE_ET_BASE_PIC32MX_H

  /*******************************************************************/
  /******** USB stack hardware selection options *********************/
  /*******************************************************************/
  //This section is the set of definitions required by the MCHPFSUSB
  //  framework.  These definitions tell the firmware what mode it is
  //  running in, and where it can find the results to some information
  //  that the stack needs.
  //These definitions are required by every application developed with
  //  this revision of the MCHPFSUSB framework.  Please review each
  //  option carefully and determine which options are desired/required
  //  for your application.

  //#define USE_SELF_POWER_SENSE_IO
  //#define tris_self_power     TRISAbits.TRISA2    // Input
  #define self_power          1

  //#define USE_USB_BUS_SENSE_IO
  //#define tris_usb_bus_sense  TRISBbits.TRISB5    // Input
  #define USB_BUS_SENSE       1 
   
  //Uncomment this to make the output HEX of this project 
  //   to be able to be bootloaded using the HID bootloader
  #define PROGRAMMABLE_WITH_USB_HID_BOOTLOADER	

  //If the application is going to be used with the HID bootloader
  //  then this will provide a function for the application to 
  //  enter the bootloader from the application (optional)
  #if defined(PROGRAMMABLE_WITH_USB_HID_BOOTLOADER)
    #define EnterBootloader() __asm__("goto 0x400")
  #endif   

  /*******************************************************************/
  /*******************************************************************/
  /*******************************************************************/
  /******** Application specific definitions *************************/
  /*******************************************************************/
  /*******************************************************************/
  /*******************************************************************/

  /** Board definition ***********************************************/
  //These defintions will tell the main() function which board is
  //  currently selected.  This will allow the application to add
  //  the correct configuration bits as wells use the correct
  //  initialization functions for the board.  These defitions are only
  //  required in the stack provided demos.  They are not required in
  //  final application design.
  #if !defined(DEMO_BOARD)
    #define DEMO_BOARD ET_BASE_PIC32MX
  #endif
    
  #define ET_BASE_PIC32MX
    
  /** LED *********************************************************************/
  // ET-BASE PIC32MX
  // LED1 = RB14
  // LED2 = RB15  
  #define mInitAllLEDs()      LATB &= 0x3FFF; TRISB &= 0x3FFF;  //0011 1111 1111 1111

  #define mLED_1              LATBbits.LATB14
  #define mLED_2              LATBbits.LATB15
  
  #define mGetLED_1()         mLED_1
  #define mGetLED_2()         mLED_2
  
  #define mLED_1_On()         mLED_1 = 1;
  #define mLED_2_On()         mLED_2 = 1;
  
  #define mLED_1_Off()        mLED_1 = 0;
  #define mLED_2_Off()        mLED_2 = 0;
 
  #define mLED_1_Toggle()     mLED_1 = !mLED_1;
  #define mLED_2_Toggle()     mLED_2 = !mLED_2;
  
  /** I/O pin definitions *****************************************************/
  #define INPUT_PIN 1
  #define OUTPUT_PIN 0

#endif  //HARDWARE_PROFILE_ET_BASE_PIC32MX_H
